﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<script runat="server">

	void dc_ContextLoad(object sender, EventArgs args)
	{
		dc.Context.Set(Soneta.Types.Date.Today);
	}

    void Grid_BeforeRow(Object sender, RowEventArgs args) {        
        Soneta.Handel.DokumentHandlowy doc = (Soneta.Handel.DokumentHandlowy)args.Row;
        if (doc.Anulowany) {
            args.VisibleRow = false;
            return;
        }
        decimal zak = doc.WartośćWCenieZakupu;
        MarzaCol.EditValue = doc.Suma.Netto-zak;
    }

</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Dokumenty sprzedaży</title> 
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server">
        <ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
        <eb:ReportHeader id="ReportHeader" title="Dokumenty sprzedaży|</STRONG>Definicja:<STRONG> {1}|</STRONG>Okres:<STRONG> {2}|</STRONG>Magazyn:<STRONG> {3}|</STRONG>Nabywca:<STRONG> {4}</STRONG>|<span style='font-size: 7pt;'>Data wydruku: {5}</span>" DataMember5="Date" runat="server" DataMember1="DokHandloweViewInfo+WParams.Definicja" DataMember2="DokHandloweViewInfo+WParams.Okres" DataMember3="DokHandloweViewInfo+WParams.Magazyn" DataMember4="DokHandloweViewInfo+WParams.Kontrahent"></eb:ReportHeader>
        <ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" OnBeforeRow="Grid_BeforeRow">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="18" Align="Left" DataMember="Numer" Caption="Numer" EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="10" Align="Center" DataMember="Data" Caption="Data~dokumentu" EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Align="Left" DataMember="Kontrahent" Total="Info" Caption="Nabywca" EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="12" Align="Right" DataMember="Suma.Netto" Total="Sum" Caption="Wartość dokumentu~Netto" Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="12" Align="Right" DataMember="Suma.VAT" Total="Sum" Caption="Wartość dokumentu~VAT" Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="12" Align="Right" DataMember="Suma.Brutto" Total="Sum" Caption="Wartość dokumentu~Brutto" Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="12" Align="Right" Total="Sum" Caption="Marża" Format="{0:n}" ID="MarzaCol" EncodeHTML="True" runat="server"></ea:GridColumn>
            </Columns>
        </ea:Grid>
        <eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
    </form>
</body>
</html>

